<?php
    $path = request()->route()->getName();
?>
<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e(getSelectedLanguage()->direction); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo $__env->yieldContent('title'); ?></title>

    <!-- Styles -->
    <link href="<?php echo e(asset('css/app.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/fa.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/ionicons.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/jquery-ui.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/daterangepicker.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/toastr.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/admin.css?version=') . getVersion()); ?>" rel="stylesheet">
    <link rel="icon" type="image/png" href="<?php echo e(asset('storage/images/FAVICON.png')); ?>">

    <?php if(getSetting('PWA') == 'enabled'): ?>
        <link rel="manifest" href="/manifest.json">
    <?php endif; ?>

    <?php echo $__env->yieldContent('style'); ?>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">
        <?php echo $__env->make('include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo $__env->make('include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <?php echo $__env->make('include.content-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <!-- Main content -->
            <section class="content">
                <div class="container-fluid">
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </section>
        </div>
        <!-- /.content-wrapper -->

        <?php echo $__env->make('include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>

    <?php if(getSetting('PWA') == 'enabled'): ?>
        <?php echo $__env->make('include.pwa-installation-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <script type="text/javascript">
            if ('serviceWorker' in navigator) {
                navigator.serviceWorker.register('/serviceworker.js', {
                    scope: '.'
                }).then(function(registration) {}, function(err) {});
            }
        </script>
    <?php endif; ?>

    <?php if(isDemoMode()): ?>
        <div id="buy-now">
            <a id="buy-now-link" href="https://codecanyon.net/cart/configure_before_adding/37367339"
                target="_blank"><span>$</span><?php echo e(config('app.script_price')); ?></a>
            <button class="buy-now-button" onclick="document.getElementById('buy-now-link').click();">
                <?php echo e(__('Buy Now')); ?>

            </button>
        </div>
    <?php endif; ?>

    <!-- Scripts -->
    <script>
        const languages = {
            user_registration: "<?php echo e(__('User Registration')); ?>",
            meetings: "<?php echo e(__('Meetings')); ?>",
            error_occurred: "<?php echo e(__('An error occurred, please try again')); ?>",
            data_updated: "<?php echo e(__('Data updated successfully')); ?>",
            valid_license: "<?php echo e(__('Your license is valid. Type: ')); ?>",
            invalid_license: "<?php echo e(__('Your license is invalid. Error: ')); ?>",
            confirmation: "<?php echo e(__('Are you sure')); ?>",
            license_uninstalled: "<?php echo e(__('License uninstalled')); ?>",
            license_uninstalled_failed: "<?php echo e(__('License uninstallation failed. Error: ')); ?>",
            update_available: "<?php echo e(__('An update is available: Version: ')); ?>",
            already_latest_version: "<?php echo e(__('Application is already at latest version. Version: ')); ?>",
            application_updated: "<?php echo e(__('The application has been successfully updated to the latest version')); ?>",
            update_failed: "<?php echo e(__('Update failed. Error: ')); ?>",
            data_added: "<?php echo e(__('Data added successfully')); ?>",
            data_deleted: "<?php echo e(__('Data deleted successfully')); ?>",
            all: "<?php echo e(__('All')); ?>",
            info: "<?php echo e(__('Showing page _PAGE_ of _PAGES_')); ?>",
            lengthMenu: "<?php echo e(__('Display _MENU_ records per page')); ?>",
            zeroRecords: "<?php echo e(__('Nothing found - sorry')); ?>",
            infoEmpty: "<?php echo e(__('No records available')); ?>",
            infoFiltered: "<?php echo e(__('filtered from _MAX_ total records')); ?>",
            next: "<?php echo e(__('Next')); ?>",
            previous: "<?php echo e(__('Previous')); ?>",
            search: "<?php echo e(__('Search')); ?>",
            jan: "<?php echo e(__('Jan')); ?>",
            feb: "<?php echo e(__('Feb')); ?>",
            mar: "<?php echo e(__('Mar')); ?>",
            apr: "<?php echo e(__('Apr')); ?>",
            may: "<?php echo e(__('May')); ?>",
            june: "<?php echo e(__('June')); ?>",
            jul: "<?php echo e(__('Jul')); ?>",
            aug: "<?php echo e(__('Aug')); ?>",
            sep: "<?php echo e(__('Sep')); ?>",
            oct: "<?php echo e(__('Oct')); ?>",
            nov: "<?php echo e(__('Nov')); ?>",
            dec: "<?php echo e(__('Dec')); ?>",
            link_copied: "<?php echo e(__('The link has been copied to the clipboard')); ?>",
            code_copied: "<?php echo e(__('The code has been copied to the clipboard')); ?>",
            token_copied: "<?php echo e(__('API Token has been copied to the clipboard')); ?>",
            free: "<?php echo e(__('Free')); ?>",
            paid: "<?php echo e(__('Paid')); ?>",
            income: "<?php echo e(__('Income')); ?>",
        };
    </script>
    <script src="<?php echo e(asset('js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/jquery-ui.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/daterangepicker.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/toastr.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/common.js?version=') . getVersion()); ?>"></script>
    <?php echo $__env->yieldContent('script'); ?>
</body>

</html>
<?php /**PATH /home/originsuiteai/webinar.originsuiteai.com/resources/views/layouts/admin.blade.php ENDPATH**/ ?>