

<?php $__env->startSection('title', getSetting('APPLICATION_NAME') . ' | ' . $page); ?>
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <section class="auth-section">
        <div class="container auth-container">
            <div class="row align-items-center h-100">
                <div class="col-md-1"></div>
                <div class="col-12 col-lg-10 main-authsection h-100">
                    <div class="row h-100 table-display">
                        <div class="col-12 col-md-6 h-100 auth-text-section">
                            <div class="text-center">
                                <div class="white-text">
                                    <h3 class="white-text"><?php echo e(__('Welcome back!')); ?></h3>
                                    <?php if(Route::has('register')): ?>
                                        <?php echo e(__('Don\'t have an account yet?')); ?><br /><a href="<?php echo e(route('register')); ?>"
                                            class="white-text"><u><?php echo e(__('Register')); ?></u></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="bg-set"></div>
                        </div>
                        <div class="col-12 col-md-6 auth-enterdata h-100">
                            <div class="card auth-info mb-0">
                                <div class="card-header text-center">
                                    <?php echo e(__('Login')); ?>

                                    <?php if(getSetting('GOOGLE_SOCIAL_LOGIN') == 'enabled' ||
                                            getSetting('FACEBOOK_SOCIAL_LOGIN') == 'enabled' ||
                                            getSetting('LINKEDIN_SOCIAL_LOGIN') == 'enabled' ||
                                            getSetting('TWITTER_SOCIAL_LOGIN') == 'enabled'): ?>
                                        <p class="mb-0 small">With social media</p>
                                    <?php endif; ?>
                                </div>
                                <div class="card-body">
                                    <?php if(session('verify')): ?>
                                        <div class="alert alert-warning" role="alert">
                                            <?php echo e(session('verify')); ?>

                                        </div>
                                    <?php endif; ?>
                                    <form id="login" method="POST" action="<?php echo e(route('login')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <?php if(getSetting('GOOGLE_SOCIAL_LOGIN') == 'enabled' ||
                                                getSetting('FACEBOOK_SOCIAL_LOGIN') == 'enabled' ||
                                                getSetting('LINKEDIN_SOCIAL_LOGIN') == 'enabled' ||
                                                getSetting('TWITTER_SOCIAL_LOGIN') == 'enabled'): ?>
                                            <div class="form-group">
                                                <div class="col-md-12 social-login-links">
                                                    <?php if(getSetting('GOOGLE_SOCIAL_LOGIN') == 'enabled'): ?>
                                                        <a href="<?php echo e(route('login.google')); ?>" class="google btn">
                                                            <i class="fab fa-google"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                    <?php if(getSetting('FACEBOOK_SOCIAL_LOGIN') == 'enabled'): ?>
                                                        <a href="<?php echo e(route('login.facebook')); ?>" class="fb btn">
                                                            <i class="fab fa-facebook-f"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                    <?php if(getSetting('LINKEDIN_SOCIAL_LOGIN') == 'enabled'): ?>
                                                        <a href="<?php echo e(route('login.linkedin')); ?>" class="linkedin btn">
                                                            <i class="fab fa-linkedin-in"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                    <?php if(getSetting('TWITTER_SOCIAL_LOGIN') == 'enabled'): ?>
                                                        <a href="<?php echo e(route('login.twitter')); ?>" class="twitter btn">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="18"
                                                                height="18" viewBox="0 0 512 512" id="twitter">
                                                                <g clip-path="url(#clip0_84_15698)">
                                                                    <path fill="#fff"
                                                                        d="M355.904 100H408.832L293.2 232.16L429.232 412H322.72L239.296 302.928L143.84 412H90.8805L214.56 270.64L84.0645 100H193.28L268.688 199.696L355.904 100ZM337.328 380.32H366.656L177.344 130.016H145.872L337.328 380.32Z">
                                                                    </path>
                                                                </g>
                                                                <defs>
                                                                    <clipPath id="clip0_84_15698">
                                                                        <rect width="512" height="512" fill="#fff">
                                                                        </rect>
                                                                    </clipPath>
                                                                </defs>
                                                            </svg>
                                                        </a>
                                                    <?php endif; ?>
                                                </div>
                                                <hr>
                                            </div>
                                        <?php endif; ?>
                                        <div class="form-group">
                                            <div class="col-12">
                                                <input id="email" type="text"
                                                    class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="email"
                                                    value="<?php echo e(old('email')); ?>"
                                                    placeholder="<?php echo e(__('E-Mail Address or Username')); ?>" maxlength="50"
                                                    required autocomplete="email" autofocus>

                                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong><?php echo e($message); ?></strong>
                                                    </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <div class="col-12">
                                                <input id="password" type="password"
                                                    class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                    placeholder="<?php echo e(__('Password')); ?>" name="password" maxlength="50"
                                                    required autocomplete="current-password">

                                                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong><?php echo e($message); ?></strong>
                                                    </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                        <?php if(getSetting('CAPTCHA_LOGIN_PAGE') == 'enabled'): ?>
                                            <div class="form-group">
                                                <div class="col-12">
                                                    <div class="g-recaptcha" id="recaptcha-div"
                                                        data-sitekey="<?php echo e(getSetting('GOOGLE_RECAPTCHA_KEY')); ?>">
                                                    </div>
                                                    <?php if($errors->has('g-recaptcha-response')): ?>
                                                        <span class="invalid-feedback" role="alert"
                                                            style="display: block">
                                                            <strong><?php echo e($errors->first('g-recaptcha-response')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endif; ?>

                                        <div class="form-group">
                                            <div class="col-12">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="remember"
                                                        id="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                                                    <label class="form-check-label" for="remember">
                                                        <?php echo e(__('Remember Me')); ?>

                                                    </label>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group row mb-0">
                                            <div class="col-12 text-center">
                                                <button id="loginButton" type="submit" class="btn btn-primary mb-2">
                                                    <?php echo e(__('Login')); ?>

                                                </button>

                                                <?php if(Route::has('password.request')): ?>
                                                    <p class="mb-0">
                                                        <a class="btn btn-link" href="<?php echo e(route('password.request')); ?>">
                                                            <?php echo e(__('Forgot Your Password')); ?>

                                                        </a>
                                                    </p>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <?php if(isDemoMode()): ?>
                                    <div>
                                        <select id="autoLogin" class="form-control">
                                            <option value="">Auto login as (demo only)</option>
                                            <option value="admin">Admin</option>
                                            <option value="user_1">User 1</option>
                                            <option value="user_2">User 2</option>
                                        </select>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script src="https://www.google.com/recaptcha/api.js"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\webinar\resources\views/auth/login.blade.php ENDPATH**/ ?>