

<?php $__env->startSection('profile-content'); ?>
    <?php echo $__env->make('include.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <form action="<?php echo e(route('profile.plan')); ?>" method="post">
        <div class="card">
            <div class="card-body">
                <?php echo csrf_field(); ?>
                
                <div class="row">
                    <div class="col-12 col-lg-6 mb-3">
                        <div class="text-muted"><?php echo e(__('Plan')); ?></div>
                        <div><?php echo e($user->plan->name); ?></div>
                    </div>

                    <?php if(!$user->planOnDefault()): ?>
                        <?php if($user->plan_payment_gateway): ?>
                            <div class="col-12 col-lg-6 mb-3">
                                <div class="text-muted"><?php echo e(__('Gateway')); ?></div>
                                <div><?php echo ucwords($user->plan_payment_gateway); ?></div>
                            </div>
                        <?php endif; ?>

                        <?php if($user->plan_amount && $user->plan_currency && $user->plan_interval): ?>
                            <div class="col-12 col-lg-6 mb-3">
                                <div class="text-muted"><?php echo e(__('Amount')); ?></div>
                                <div><?php echo e(formatMoney($user->plan_amount, $user->plan_currency)); ?> <?php echo e($user->plan_currency); ?> /
                                    <span
                                        class="text-lowercase"><?php echo e($user->plan_interval == 'month' || $user->plan_interval == 'monthly' ? __('Month') : __('Year')); ?></span>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if($user->plan_recurring_at): ?>
                            <div class="col-12 col-lg-6 mb-3">
                                <div class="text-muted"><?php echo e(__('Recurring at')); ?></div>
                                <div><?php echo e($user->plan_recurring_at); ?></div>
                            </div>
                        <?php endif; ?>

                        <?php if($user->plan_trial_ends_at && $user->plan_trial_ends_at->gt(Carbon\Carbon::now())): ?>
                            <div class="col-12 col-lg-6 mb-3">
                                <div class="text-muted"><?php echo e(__('Trial ends at')); ?></div>
                                <div><?php echo e($user->plan_trial_ends_at); ?></div>
                            </div>
                        <?php endif; ?>

                        <?php if($user->plan_ends_at): ?>
                            <div class="col-12 col-lg-6 mb-3">
                                <div class="text-muted"><?php echo e(__('Ends at')); ?></div>
                                <div><?php echo e($user->plan_ends_at); ?></div>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
                <?php if($user->plan_recurring_at): ?>
                    <button type="button" class="btn btn-outline-danger mb-3" data-toggle="modal"
                        data-target="#cancel-modal"><?php echo e(__('Cancel')); ?></button>
                <?php endif; ?>

                <?php if(getAuthUserInfo('role') != 'admin'): ?>
                    <a href="<?php echo e(route('pricing')); ?>">
                        <button type="button" name="submit" class="btn btn-primary mb-3"><?php echo e(__('Upgrade')); ?></button>
                    </a>
                <?php endif; ?>
            </div>
        </div>      
    </form>

    <div class="modal fade" id="cancel-modal" tabindex="-1" role="dialog" aria-labelledby="cancel-modal-label"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content border-0 shadow">
                <div class="modal-header">
                    <h6 class="modal-title" id="cancel-modal-label"><?php echo e(__('Cancel')); ?></h6>
                    <button type="button" class="close d-flex align-items-center justify-content-center width-12 height-14"
                        data-dismiss="modal" aria-label="Close">
                    </button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <?php echo e(__('You\'ll continue to have access to the features you\'ve paid for until the end of your billing cycle.')); ?>

                    </div>
                    <div><?php echo e(__('Are you sure you want to cancel :name?', ['name' => $user->plan->name])); ?></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                    <form action="<?php echo e(route('cancelPlan')); ?>" method="post">

                        <?php echo csrf_field(); ?>

                        <button type="submit" class="btn btn-danger"><?php echo e(__('Cancel')); ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('profile.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/originsuiteai/webinar.originsuiteai.com/resources/views/profile/plan.blade.php ENDPATH**/ ?>