import * as flatbuffers from 'flatbuffers';
import { Uint32String, Uint32StringT } from '../../fbs/common/uint32-string';
import { SctpState } from '../../fbs/sctp-association/sctp-state';
import { SctpParameters, SctpParametersT } from '../../fbs/sctp-parameters/sctp-parameters';
import { RecvRtpHeaderExtensions, RecvRtpHeaderExtensionsT } from '../../fbs/transport/recv-rtp-header-extensions';
import { RtpListener, RtpListenerT } from '../../fbs/transport/rtp-listener';
import { SctpListener, SctpListenerT } from '../../fbs/transport/sctp-listener';
import { TraceEventType } from '../../fbs/transport/trace-event-type';
export declare class Dump implements flatbuffers.IUnpackableObject<DumpT> {
    bb: flatbuffers.ByteBuffer | null;
    bb_pos: number;
    __init(i: number, bb: flatbuffers.ByteBuffer): Dump;
    static getRootAsDump(bb: flatbuffers.ByteBuffer, obj?: Dump): Dump;
    static getSizePrefixedRootAsDump(bb: flatbuffers.ByteBuffer, obj?: Dump): Dump;
    id(): string | null;
    id(optionalEncoding: flatbuffers.Encoding): string | Uint8Array | null;
    direct(): boolean;
    producerIds(index: number): string;
    producerIds(index: number, optionalEncoding: flatbuffers.Encoding): string | Uint8Array;
    producerIdsLength(): number;
    consumerIds(index: number): string;
    consumerIds(index: number, optionalEncoding: flatbuffers.Encoding): string | Uint8Array;
    consumerIdsLength(): number;
    mapSsrcConsumerId(index: number, obj?: Uint32String): Uint32String | null;
    mapSsrcConsumerIdLength(): number;
    mapRtxSsrcConsumerId(index: number, obj?: Uint32String): Uint32String | null;
    mapRtxSsrcConsumerIdLength(): number;
    dataProducerIds(index: number): string;
    dataProducerIds(index: number, optionalEncoding: flatbuffers.Encoding): string | Uint8Array;
    dataProducerIdsLength(): number;
    dataConsumerIds(index: number): string;
    dataConsumerIds(index: number, optionalEncoding: flatbuffers.Encoding): string | Uint8Array;
    dataConsumerIdsLength(): number;
    recvRtpHeaderExtensions(obj?: RecvRtpHeaderExtensions): RecvRtpHeaderExtensions | null;
    rtpListener(obj?: RtpListener): RtpListener | null;
    maxMessageSize(): number;
    sctpParameters(obj?: SctpParameters): SctpParameters | null;
    sctpState(): SctpState | null;
    sctpListener(obj?: SctpListener): SctpListener | null;
    traceEventTypes(index: number): TraceEventType | null;
    traceEventTypesLength(): number;
    traceEventTypesArray(): Uint8Array | null;
    static startDump(builder: flatbuffers.Builder): void;
    static addId(builder: flatbuffers.Builder, idOffset: flatbuffers.Offset): void;
    static addDirect(builder: flatbuffers.Builder, direct: boolean): void;
    static addProducerIds(builder: flatbuffers.Builder, producerIdsOffset: flatbuffers.Offset): void;
    static createProducerIdsVector(builder: flatbuffers.Builder, data: flatbuffers.Offset[]): flatbuffers.Offset;
    static startProducerIdsVector(builder: flatbuffers.Builder, numElems: number): void;
    static addConsumerIds(builder: flatbuffers.Builder, consumerIdsOffset: flatbuffers.Offset): void;
    static createConsumerIdsVector(builder: flatbuffers.Builder, data: flatbuffers.Offset[]): flatbuffers.Offset;
    static startConsumerIdsVector(builder: flatbuffers.Builder, numElems: number): void;
    static addMapSsrcConsumerId(builder: flatbuffers.Builder, mapSsrcConsumerIdOffset: flatbuffers.Offset): void;
    static createMapSsrcConsumerIdVector(builder: flatbuffers.Builder, data: flatbuffers.Offset[]): flatbuffers.Offset;
    static startMapSsrcConsumerIdVector(builder: flatbuffers.Builder, numElems: number): void;
    static addMapRtxSsrcConsumerId(builder: flatbuffers.Builder, mapRtxSsrcConsumerIdOffset: flatbuffers.Offset): void;
    static createMapRtxSsrcConsumerIdVector(builder: flatbuffers.Builder, data: flatbuffers.Offset[]): flatbuffers.Offset;
    static startMapRtxSsrcConsumerIdVector(builder: flatbuffers.Builder, numElems: number): void;
    static addDataProducerIds(builder: flatbuffers.Builder, dataProducerIdsOffset: flatbuffers.Offset): void;
    static createDataProducerIdsVector(builder: flatbuffers.Builder, data: flatbuffers.Offset[]): flatbuffers.Offset;
    static startDataProducerIdsVector(builder: flatbuffers.Builder, numElems: number): void;
    static addDataConsumerIds(builder: flatbuffers.Builder, dataConsumerIdsOffset: flatbuffers.Offset): void;
    static createDataConsumerIdsVector(builder: flatbuffers.Builder, data: flatbuffers.Offset[]): flatbuffers.Offset;
    static startDataConsumerIdsVector(builder: flatbuffers.Builder, numElems: number): void;
    static addRecvRtpHeaderExtensions(builder: flatbuffers.Builder, recvRtpHeaderExtensionsOffset: flatbuffers.Offset): void;
    static addRtpListener(builder: flatbuffers.Builder, rtpListenerOffset: flatbuffers.Offset): void;
    static addMaxMessageSize(builder: flatbuffers.Builder, maxMessageSize: number): void;
    static addSctpParameters(builder: flatbuffers.Builder, sctpParametersOffset: flatbuffers.Offset): void;
    static addSctpState(builder: flatbuffers.Builder, sctpState: SctpState): void;
    static addSctpListener(builder: flatbuffers.Builder, sctpListenerOffset: flatbuffers.Offset): void;
    static addTraceEventTypes(builder: flatbuffers.Builder, traceEventTypesOffset: flatbuffers.Offset): void;
    static createTraceEventTypesVector(builder: flatbuffers.Builder, data: TraceEventType[]): flatbuffers.Offset;
    static startTraceEventTypesVector(builder: flatbuffers.Builder, numElems: number): void;
    static endDump(builder: flatbuffers.Builder): flatbuffers.Offset;
    unpack(): DumpT;
    unpackTo(_o: DumpT): void;
}
export declare class DumpT implements flatbuffers.IGeneratedObject {
    id: string | Uint8Array | null;
    direct: boolean;
    producerIds: (string)[];
    consumerIds: (string)[];
    mapSsrcConsumerId: (Uint32StringT)[];
    mapRtxSsrcConsumerId: (Uint32StringT)[];
    dataProducerIds: (string)[];
    dataConsumerIds: (string)[];
    recvRtpHeaderExtensions: RecvRtpHeaderExtensionsT | null;
    rtpListener: RtpListenerT | null;
    maxMessageSize: number;
    sctpParameters: SctpParametersT | null;
    sctpState: SctpState | null;
    sctpListener: SctpListenerT | null;
    traceEventTypes: (TraceEventType)[];
    constructor(id?: string | Uint8Array | null, direct?: boolean, producerIds?: (string)[], consumerIds?: (string)[], mapSsrcConsumerId?: (Uint32StringT)[], mapRtxSsrcConsumerId?: (Uint32StringT)[], dataProducerIds?: (string)[], dataConsumerIds?: (string)[], recvRtpHeaderExtensions?: RecvRtpHeaderExtensionsT | null, rtpListener?: RtpListenerT | null, maxMessageSize?: number, sctpParameters?: SctpParametersT | null, sctpState?: SctpState | null, sctpListener?: SctpListenerT | null, traceEventTypes?: (TraceEventType)[]);
    pack(builder: flatbuffers.Builder): flatbuffers.Offset;
}
//# sourceMappingURL=dump.d.ts.map