<!-- Navbar -->
<nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent"
        aria-controls="navbarSupportedContent" aria-expanded="false"
        aria-label="<?php echo e(__('Toggle navigation')); ?>">
        <span class="navbar-toggler-icon"></span>
    </button>

    <!-- Left Side Of Navbar -->
    <ul class="navbar-nav mr-auto">
        <li class="nav-item">
            <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i
                    class="fas fa-bars"></i></a>
        </li>
    </ul>

    <!-- Right Side Of Navbar -->
    <ul class="navbar-nav ml-auto">
        <?php if(getLanguages()->count() > 1): ?>
            <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button"
                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <i class="fa fa-globe"></i> <?php echo e(getSelectedLanguage()->name); ?>

                </a>
                <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                    <?php $__currentLoopData = getLanguages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a class="dropdown-item <?php if(getSelectedLanguage()->name == $language->name): ?> active <?php endif; ?>"
                            href="<?php echo e(route('language', ['locale' => $language->code])); ?>"><?php echo e($language->name); ?></a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </li>
        <?php endif; ?>

        <!-- Authentication Links -->
        <?php if(auth()->guard()->guest()): ?>
            <?php if(Route::has('login')): ?>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('login')); ?>"><?php echo e(__('Login')); ?></a>
                </li>
            <?php endif; ?>

            <?php if(Route::has('register')): ?>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('register')); ?>"><?php echo e(__('Register')); ?></a>
                </li>
            <?php endif; ?>
        <?php else: ?>
            <?php if(getAuthUserInfo('role') == 'admin'): ?>
                <li class="nav-item">
                    <a class="nav-link active" href="<?php echo e(route('admin')); ?>"><?php echo e(__('Admin')); ?></a>
                </li>
            <?php endif; ?>

            <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
            </li>

            <li class="nav-item dropdown">
                <a id="profileDropdown" class="nav-link dropdown-toggle set-profile" href="#" role="button"
                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                    <?php echo e(getAuthUserInfo('username')); ?>

                </a>

                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="profileDropdown">
                    <a class="dropdown-item" href="<?php echo e(route('profile.profile')); ?>">
                        <?php echo e(__('Profile')); ?>

                    </a>
                    <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                        onclick="event.preventDefault();
                                                                                     document.getElementById('logout-form').submit();">
                        <?php echo e(__('Logout')); ?>

                    </a>

                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                        <?php echo csrf_field(); ?>
                    </form>
                </div>
            </li>
        <?php endif; ?>
    </ul>
</nav>
<!-- /.navbar --><?php /**PATH C:\laragon\www\webinar\resources\views/include/header.blade.php ENDPATH**/ ?>